import pandas as pd   
import pickle
from decision_company import read_csv_file, count_unique_values, bind_dataframe, pivot_a_level, fill_missing_values, make_bins 

# Load the dataset  
credit_customers = read_csv_file("credit_customers.csv")  
  
credit_customers['credit_amount_range'] = make_bins(credit_customers['credit_amount'], bins=[0, 2000, 4000, 6000, 8000, 10000, 12000, 14000, 16000, 18000, 20000], include_lowest=True)  
credit_amount_group = bind_dataframe(credit_customers, 'credit_amount_range')  
credit_amount_counts = count_unique_values(credit_amount_group['class'], normalize=True)  
approval_rates_credit_amount = fill_missing_values(pivot_a_level(credit_amount_counts), value=0)['good']  
 
print(approval_rates_credit_amount)
pickle.dump(approval_rates_credit_amount,open("./ref_result/approval_rates_credit_amount.pkl","wb"))

  